// Background service worker for Clip2Post extension

// Store the latest selected text
let lastSelection = '';

// Create context menu on install
chrome.runtime.onInstalled.addListener(() => {
    chrome.contextMenus.create({
        id: 'clip2post-repurpose',
        title: 'Repurpose with AI',
        contexts: ['selection'],
    });
});

// Handle context menu click
chrome.contextMenus.onClicked.addListener((info, tab) => {
    if (info.menuItemId === 'clip2post-repurpose' && info.selectionText) {
        // Store the selection
        lastSelection = info.selectionText;

        // Save to storage for the popup to read
        chrome.storage.local.set({ lastSelection: info.selectionText }, () => {
            // Open the popup
            chrome.action.openPopup();
        });
    }
});

// Listen for messages from content script
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
    if (message.type === 'SELECTION_CAPTURED') {
        lastSelection = message.text;
        chrome.storage.local.set({ lastSelection: message.text });
        sendResponse({ success: true });
    }

    if (message.type === 'GET_SELECTION') {
        sendResponse({ text: lastSelection });
    }

    return true; // Keep channel open for async response
});

// Handle keyboard shortcut (optional)
chrome.commands?.onCommand?.addListener((command) => {
    if (command === 'open-popup') {
        chrome.action.openPopup();
    }
});
